/**
 * @file: svg_font_err.h
 *
 * @version: $Id: svg_font_err.h,v 1.20 2011/06/27 08:44:08 efriedrich Exp $
 *
 * contains definition of common error types
 *
 * @component: svg_font
 *
 * @author: D.Langner
 *
 * @copyright: (c) 2003  2008 ADIT Corporation
 *
 * @see <related items>
 * 
 * @history
 *
 ***********************************************************************/
 
#ifndef SVG_FONT_ERROR_H
#define SVG_FONT_ERROR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "svg_error.h"

typedef enum {
	/* svg and grl font errors from -300 to -200 */
    GRL_FONT_READ_DEVCONF_FAILED = SVG_FONT_ERROR,
    SVG_FREETYPE_ERROR,								/*-299*/
    SVG_NULL_CHARACTER,								
    GRL_IMAGE_CRAETION_FAILED,					
    GRL_MIPMAPPING_NOT_SUPPORTED,
    SVG_FONT_CONTEXT_IN_USE,
	SVG_FONT_FILESYSTEM_ERROR,
	SVG_EGL_ERROR,
	SVG_OPENGL_ERROR,
	SVG_OPENVG_ERROR,
	MODULE_INIT_FAILED,								/*-290*/
	BUILDING_FONT_DATABASE_FAILED,
	ALREADY_INITIALIZED,
	NOT_YET_INITIALIZED,
	CREATE_MODULE_INFO_LIST_FAILED,
	DESTROY_MODULE_INFO_LIST_FAILED,
	CREATE_MODULE_INFO_FAILED,
	DESTROY_MODULE_INFO_FAILED,
	CREATE_MODULE_FAILED,
	DESTROY_MODULE_FAILED,
	DESTROY_FLASH_FONT,								/*-280*/
	DESTROY_FILE_FONT,
	CREATE_POINTER_FAILED,
	DESTROY_POINTER_FAILED,
    OPEN_FILE_FONT_ERROR,
    OPEN_MEM_FONT_ERROR,
    INITIALIZE_FREETYPE_FAILED,
    CREATE_FREETYPE_LIB_FAILED,
    DESTROY_FREETYPE_LIB_FAILED,
    CREATE_FREETYPE_FACE_FAILED,
    DESTROY_FREETYPE_FACE_FAILED,					/*-270*/
    COMPILE_SHADER_FAILED,
    LINK_SHADER_FAILED,
    VALIDATE_SHADER_FAILED,
    UNSUPPORTED_API,
    CONTEXT_IN_USE,
	OPEN_PATH_ERROR,
	CLOSE_PATH_ERROR,
	FAIL_ADD_WALLPAPER,
	VG_IMAGE_FAIL,
	CACHE_ELEMENT_NOT_AVAILABLE,					/*-260*/
	STROKER_CREATION_FAILED,
	STROKER_DONE_FAIL,
	FACE_DONE_FAIL,
	FREETYPE_DONE_FAIL,
    VG_TEXTURE_CREATION_FAIL,
    GL_TEXTURE_CREATION_FAIL,
    SET_PIXEL_SIZE_FAIL,
    SVG_FILE_IO_ERROR,
    OPENGL_NOT_LINKED,
    OPENVG_NOT_LINKED,								/*-250*/
    CREATING_SEMAPHORE_FAILED,
	HASHENTRY_REMOVE_ERROR,
	TOO_MANY_GLYPHS_FOR_CACHE,
	OPEN_DUMP_FILE_ERROR,
	SEM_OPEN_FAILED,
	SHM_OPEN_FAILED,
	SHM_STATE_FAILED,
	SHM_SIZE_FAILED,
	SHM_MMAP_FAILED,
	SEM_POST_FAILED,
	SEM_WAIT_FAILED,
	OPENING_PARSED_FILE_FAILED,
	SEM_CHMOD_FAILED,
	SHM_CHMOD_FAILED,
	EXCEED_ALLOCATED_MEMORY,
	HB_FONT_HNDL_CREATION_FAILED,
	HB_BUFFER_CREATION_FAILED,
    HB_PLUGIN_INIT_FAILED,
    TEXT_TOO_LARGE
} TR_FONT_ERROR;

/* END ARRAY_DEFINE */

#ifdef __cplusplus
}
#endif


#endif /* SVG_FONT_ERROR */
